function [last_episodes, av_all_episodes]=simulation_rep(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,a2,K)

%This function returns:

%last_episodes: A K x 7 matrix containing for each experiment k, the
%values in the last episode T of A_N (quoted price of AMM N) and opt_N (greedy price of AMM N) for each AMM, 
%as well as v_tilde (asset's fundamental value), l (trader's liquidity shock), 
%C_T (number of consecutive episodes before T in which all AMMs play the same price as in T).

%The columns of last_episodes are ordered as follows:
%1: A_1
%2: A_2 (set to 5.0)
%3: opt_1
%4: opt_2 (set to 5.0)
%5: v_tilde
%6: l
%7: C_T

%av_all_episodes: A Tx8 matrix containing for each episode t the mean across experiments 
%of A_1 (quoted price of AMM 1), the mean of opt_1 (greedy price of AMM 1),
%the mean of Profit_1 (profit of AMM 1), the mean of a_min (lowest quoted price), 
%and the means of the same variables squared. 

%The columns of av_all_episodes are ordered as follows:
%1: mean(A_1)
%2: mean(opt_1)
%3: mean(Profit_1)
%4: mean(a_min)
%5: mean(A_1^2)
%6: mean(opt_1^2)
%7: mean(Profit_1^2)
%8: mean(a_min^2)

%Initialize

last_episodes = zeros(K,7);
av_all_episodes = zeros(T,8);

%Run K experiments.
%Replace "parfor" with "for" to run without parallelization.

parfor k=1:K
    %Calls the function simulation_exp
    [last_episode,all_episodes] = simulation_exp(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,a2);
    %Records the last episode
    last_episodes(k,:) = last_episode;
    %Adds the values of all episodes to the existing av_all_episodes
    av_all_episodes = av_all_episodes + all_episodes;
    %Uncomment the next line to follow the execution of the code
    %disp(k)
end

%Divide by K to get the average across all experiments:
av_all_episodes = av_all_episodes/K;
